#:t:::::::::::::::::g@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#:t::::::::::::::;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#:::::::::::::z;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#::::::::::::i@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#::::::::::::@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@$@@@@
#:::::::::::3@@@@@@@@@@@@@@@@@@@@@@@@@B@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#::::::::::3@@@@@@@@@@@@@@@@@@@@@BEEESSE5EEEEBBM@@@@@@@@@@@@@@@@@@@@@@@@@@
#::::::::::3@@@@@@@@@@@@@@@@@@@@BEEEEEE35EE55E2355E5SBMB@@@@@@@@@@@@@@@@@$
#::::::::::@@@@@@@@@@@@@@@@@@@EEEE55533t3tttt::::::!!!!7755E755SBBMMM@@@MM
#::::::::::3@@@@@@@@@@@@@@@@@@EEEE2t3ttttt:::::::::::::::::::::::!7?5225EE
#::::::::::3@@@@@@@@@@@@@@@@@@EEEEE31t::::::::::::::::::::::::::::::::3E5@
#::::::::::3@@@@@@@@@@@@@@@@@@EEEEEEtt:::::::::::::::::::::::::::::::::353
#::::::::::3@@@@@@@@@@@@@@@@@@EEEEEE1ttz::::::::::::::::::::::::::::::::35
#:::::::::::@@@@@@@@@@@@@@@@@@EEEEEEEtz1::::::::::::::::::::::::::::::::t:
#:::::::::!3@@@@@@@@@@@@@@@@@@@EEEEEttt::::::::::::::::::::::::::::::::;zz
#::::::::::@@@@@@@@@@@@@@@@@@@@EEEEEttt:::::z;z:::::::::::::::::::::::::13
#::::::::::3B@@@@@@@@@@@@@@@@@@EEEEEEE3tt:czzztti;:::::::::::::::::::::::3
#::::ttt::::3@@@@@@@@@@@@@@@@EEEEE5EE25Ezt1EEEz5Etzzz;;;;:::::::::::::::::
#:::::::::::I9@@@@@@@@@@@@@@@@@@@@@@@@@@EEEEEE@@@@@@@@@@@@@@Ez;:::::::::::
#:::::::::::::E@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@Ez::::::
#::::::::::::::E@@@@@@@@@@@@@@@@@@@@@@@@@@@@@BE5EBB@@@@@@@@@@@@@@@EEE:::::
#:::::::::::::::@@@@@@@@@@@@@@@@@@@@@@@@@@@@E1::35@@@@@@@@@@ME3MMME2::::::
#:::::::::::::::?@@@@@@@@@@@@@@@@@@M@@@@@@@EE:::::3SB@@BBESEEt::::::::::::
#::::::::::::::::J$@@@@@@@B@@@@@@@@@@@@@@@@EE:::::::!35E33t:::::::::::::::
#:::::::::::::::::3@E@@@EE5EESE5EESE@@@@@@@Et::::::::::::tz:::::::::::::::
#:::::::::::::::::J@E$@EEE5133555SE@@@@@@@@Et:::::::::::::::::::::::::::::
#::::::::::::::::::E@E@EEEEtt3523EEE@@@@@@@E::::::::::::::::::::::::::::::
#:t::::::::::::::::JEE3@@@EEEEEEEEEE@@@@@@@E:::::::::t;:::::::::::::::::::
#:t:::::::::::::::::!5ES@EEEEEEEEES@@@@@@@@@E;:::;;;:3Ez::::::::::::::::::
#:t::::::::::::::::::::JE@@EEEEEEE@@@@@@@@@@@@@@@@ME!:::;:::::::::::::::::
#:tz::::::::::::::::::::JE@@@EEEE@@@@@@@@@@@@@@EE!:::::::t::::::::::::::::
#:t::::::::::::::::::::::3@@@@@@@@@@@@@@@@@@ESBE::::::::::::::::::::::::::
#:::::::::::::::::::::::::Q@@@@@@@@@@@@@@@@EE3EE;:::::zzzz::::::::::::::::
#:::::::::::::::::::::::::3@@@@@@@@@@@@@@@@@@@@@@NN@@@@@@Ez:::::::::::::::
#:zt:::::::::::::::::::::::3@@@@EE@@@@@@@@@@EEEEt::;z113E5t:::::::::::::::
#::tt:::::::::::::::::::::::3@@@E@@@@@@@@@@@@@@@@BEt::::::::::::::::t:::::
#:tt:t:::::::::::::::::::::::?S@@@@@@@@@@@BBEEE51!::::::::::::::zzzEt:::::
#::::::::::::::::::::::::::::::3Q@@@@@@@BEEEEEt:::::::::::::;zz@@@EE::::::
#::::::::::::::::::::::::::::::::75B@@@@@EEEtt;:::::::::;zz@@@@BEEEtz:::::
#::::::::::::::::::::::::::::::::::::?9@@@@@@@@@@@E2Ezg@@@@@B@@@EEEE1t::::
#:::::::::::::::::::::::::::::::::::::::3@@@@@@@@@@@@@@@@@@@E@EEEEEEEzzz::
#::::::::::::::::::::::::::::::::::::;@@@@@@@@@@@@@@@@@@@@@@@EEEEEEE5ttttt
#:::::::::::::::::::::::::::::::;g@@@@@@@@@@@@@@@@@@@@@@@@@@EEEEEEEEEEEtzt
#::::::::::::::::::::::::::::;@@@@@@@@@@@@@@@@@@@@@@@@@@E@@EEEEEEEEEEEE@@@
#::::::::::::::::::::::::::g@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@EEEE3EEEE@@@@@@@
#:::::::::::::::::::::;;g@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@EEEt33@@@@@@@@@@
#:::::::::::::::::;g@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@E@@@@@@EEEtg@@@@@@@@@@@@
#::::::::::::::;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@EEEE@@@@@@@@@@@@@@@@@@@@@@@@
#:::::::::::::@@@@@@@@@@@@@@@@@$@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#::::::::::;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#
# Copyleft ↄ⃝ 2012 Institut Curie
# Author(s): Valentina Boeva, Alban Lermine (Institut Curie) 2012
# Contact: valentina.boeva@curie.fr, alban.lermine@curie.fr
# This software is distributed under the terms of the GNU General
# Public License, either Version 2, June 1991 or Version 3, June 2007.

#!/bin/bash

REG="NA"
CONTROLFILE="NA"

while getopts "f:c:l:o:r:u:v:e:p:" optionName; do
case "$optionName" in

f) CHIPFILE="$OPTARG";;
c) CONTROLFILE="$OPTARG";;
l) STEP="$OPTARG";;
r) RIGHT="$OPTARG";;
o) OUTPUT="$OPTARG";;
u) OUTSTAT="$OPTARG";;
v) GENOME="$OPTARG";;
e) REG="$OPTARG";;
p) PDF="$OPTARG";;

esac
done

LOCAL_DIR=`( cd -P $(dirname $0); pwd)`

if [ -r $REG ]; then
  perl $LOCAL_DIR/crossBedWithGenes.pl -g $LOCAL_DIR/$GENOME.noIdenticalTransc.txt -f $CHIPFILE -reg $REG -o $OUTPUT.annotated >>/dev/null 2>>/dev/null
 else
  perl $LOCAL_DIR/crossBedWithGenes.pl -g $LOCAL_DIR/$GENOME.noIdenticalTransc.txt -f $CHIPFILE -o $OUTPUT.annotated >>/dev/null 2>>/dev/null
fi

#########previous version:
if [ -r $CONTROLFILE ]; then
   perl $LOCAL_DIR/createControlPeakSubSet.pl -f $CHIPFILE -c $CONTROLFILE -o $CONTROLFILE.tmp >>/dev/null 2>>/dev/null
  if [ -r $REG ]; then
    perl $LOCAL_DIR/crossBedWithGenes.pl -g $LOCAL_DIR/$GENOME.noIdenticalTransc.txt -f $CONTROLFILE.tmp -reg $REG -o $OUTPUT.control.annotated >>/dev/null 2>>/dev/null
  else
    perl $LOCAL_DIR/crossBedWithGenes.pl -g $LOCAL_DIR/$GENOME.noIdenticalTransc.txt -f $CONTROLFILE.tmp -o $OUTPUT.control.annotated >>/dev/null 2>>/dev/null
  fi
  cat $LOCAL_DIR/makeTSSdist.R | R --slave --args $STEP $RIGHT $OUTPUT.annotated $OUTPUT $OUTSTAT $OUTPUT.control.annotated $PDF >>/dev/null 2>>/dev/null
else
  cat $LOCAL_DIR/makeTSSdist.R | R --slave --args $STEP $RIGHT $OUTPUT.annotated $OUTPUT $OUTSTAT $PDF 2>>/dev/null >>/dev/null
fi
#########end previous version##############


#########bootstrap version:
#if [ -r $CONTROLFILE ]; then   
#  if [ -r $REG ]; then
#    perl $LOCAL_DIR/crossBedWithGenes.pl -g $LOCAL_DIR/$GENOME.noIdenticalTransc.txt -f $CONTROLFILE -reg $REG -o $OUTPUT.control.annotated >> $LOGTMP 2>> $LOGTMP
#  else
#    perl $LOCAL_DIR/crossBedWithGenes.pl -g $LOCAL_DIR/$GENOME.noIdenticalTransc.txt -f $CONTROLFILE -o $OUTPUT.control.annotated >> $LOGTMP 2>> $LOGTMP
#  fi
#  echo "3: cat $LOCAL_DIR/makeTSSdist_bootstrap.R | /bioinfo/local/R/bin/R --slave --args $STEP $RIGHT $OUTPUT.annotated $OUTPUT $OUTSTAT $OUTPUT.control.annotated $PDF $NUMBER_BOOTSTRAP" >> $LOGTMP
#  cat $LOCAL_DIR/makeTSSdist.R | /bioinfo/local/R/bin/R --slave --args $STEP $RIGHT $OUTPUT.annotated $OUTPUT $OUTSTAT $OUTPUT.control.annotated $PDF $NUMBER_BOOTSTRAP>>$LOGTMP 2>>$LOGTMP
#else
#  echo "4:  cat $LOCAL_DIR/makeTSSdist.R | /bioinfo/local/R/bin/R --slave --args $STEP $RIGHT $OUTPUT.annotated $OUTPUT $OUTSTAT $PDF 2>>$LOGTMP" >>$LOGTMP
#  cat $LOCAL_DIR/makeTSSdist.R | /bioinfo/local/R/bin/R --slave --args $STEP $RIGHT $OUTPUT.annotated $OUTPUT $OUTSTAT $PDF 2>>$LOGTMP >>$LOGTMP
#fi

#exit
#########end bootstrap version##############


rm $OUTPUT.annotated*

if [ -r $CONTROLFILE ]; then
  rm $OUTPUT.control.annotated*
  #rm $CONTROLFILE.tmp
fi

